package org.example.kotlin.multiplatform.backend

import io.ktor.application.Application
import io.ktor.application.call
import io.ktor.application.install
import io.ktor.http.*
import io.ktor.http.content.*
import io.ktor.response.respond
import io.ktor.routing.*
import org.example.kotlin.multiplatform.Greetings

fun Application.main() {
    install(Routing) {
        accept(ContentType.Text.Html) {
            defaultResource("index.html")
        }

        get("greetings") { call.respond(Greetings("Kotlin/Backend").greet()) }
    }
}
