.ONESHELL:

# Files, directories and Aliases
################################

MAGIC_LOG=$(LOG_DIR)/$(TIMESTAMP_TIME)-magic-$(TOP).log
MAGIC_LVS_LOG=$(LOG_DIR)/$(TIMESTAMP_TIME)-magic-lvs-$(TOP).log
MAGIC_PEX_LOG=$(LOG_DIR)/$(TIMESTAMP_TIME)-magic-pex-$(TOP).log

MAGIC=magic -rcfile $(MAGIC_RCFILE) -noconsole
MAGIC_BATCH=$(MAGIC) -nowrapper -nowindow -D -dnull

define MAGIC_ROUTINE_LOAD =

drc off
if { "$(suffix $(TOP_GDS))" == ".gds" } {
	puts "Reading a gds"
	gds readonly true
	gds rescale false
	gds read $(TOP_GDS)
	getcell $(TOP_GDS_CELL)
	load $(TOP_GDS_CELL)
	box 0 0 0 0
} else {
	load $(TOP_GDS)
}
endef

define MAGIC_ROUTINE_LVS =
drc off
$(MAGIC_ROUTINE_LOAD)

extract
ext2spice lvs
ext2spice -o "$(TOP_GDS_DIR)/$(TOP_GDS_CELL)_extracted.spice"

puts "Created netlist file $(TOP_GDS_DIR)/$(TOP_GDS_CELL)_extracted.spice"
quit -noprompt
endef

define MAGIC_ROUTINE_PEX =
drc off
$(MAGIC_ROUTINE_LOAD)

flatten $(TOP_GDS_CELL)_pex
load $(TOP_GDS_CELL)_pex
box values 0 0 0 0
#box 0 0 0 0

extract all
ext2sim labels on
ext2sim
extresist tolerance 10
extresist all
ext2spice lvs
ext2spice extresist on
ext2spice cthresh 0
ext2spice -o "$(TOP_GDS_DIR)/$(TOP_GDS_CELL)_pex.spice"

puts "Created pex file $(TOP_GDS_DIR)/$(TOP_GDS_CELL)_pex.spice"

quit -noprompt
endef

define HELP_ENTRIES +=

Magic related rules:
  magic-validation:  Evaluates relevant file existence. It's used by other rules.
  magic-edit:        Open $(TOP).gds on magic
  magic-lvs:         Extracts the netlist without parasitics
  magic-pex:         Extracts the netlist with resistive and capacitive parasitics

endef

# Rules
#######

.PHONY: magic-validation
magic-validation:
ifeq (,$(wildcard $(TOP_GDS)))
	$(call ERROR_MESSAGE, [magic] GDS file $(TOP_GDS) doesn't exist$)
endif
	$(call INFO_MESSAGE, [magic] directory:         $(TOP_GDS_DIR))
	$(call INFO_MESSAGE, [magic] GDS:               $(TOP_GDS))
	$(call INFO_MESSAGE, [magic] extracted netlist: $(wildcard $(TOP_GDS_DIR)/$(TOP)_extracted.spice))
	$(call INFO_MESSAGE, [magic] extracted pex:     $(wildcard $(TOP_GDS_DIR)/$(TOP)_pex.spice))
	$(call INFO_MESSAGE, [magic] rcfile:            $(MAGIC_RCFILE))


.PHONY: magic-edit
magic-edit: magic-validation
	cd $(TOP_GDS_DIR) && $(MAGIC) <<EOF |& tee $(MAGIC_LOG)
	$(MAGIC_ROUTINE_LOAD)
	EOF


# Working on the TOP_DIR for simplicity, maybe we can change a internal variable to write all there.
.PHONY: magic-lvs
magic-lvs: magic-validation
	cd $(TOP_GDS_DIR) && $(MAGIC_BATCH) <<EOF |& tee $(MAGIC_LVS_LOG)
	$(MAGIC_ROUTINE_LVS)
	EOF
	


.PHONY: magic-pex
magic-pex: magic-validation
	cd $(TOP_GDS_DIR) && $(MAGIC_BATCH) <<EOF |& tee $(MAGIC_PEX_LOG)
	$(MAGIC_ROUTINE_PEX)
	EOF
