/*
 * Decompiled with CFR 0.152.
 */
package com.beust.kobalt.wrapper;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class Main {
    private static final String KOBALT_PROPERTIES = "kobalt.properties";
    private static final String KOBALTW = "kobaltw";
    private static final String KOBALT_WRAPPER_PROPERTIES = "kobalt-wrapper.properties";
    private static final String PROPERTY_VERSION = "kobalt.version";
    private static final String URL = "https://dl.bintray.com/cbeust/generic/";
    private static final String FILE_NAME = "kobalt";
    private static final String DISTRIBUTIONS_DIR = System.getProperty("user.home") + "/.kobalt/wrapper/dist";
    private final Properties wrapperProperties = new Properties();
    private static int logLevel = 1;
    private static final String[] FILES = new String[]{"kobaltw", "kobalt/wrapper/kobalt-wrapper.jar"};
    private static final String KOBALT_MAIN_CLASS = "com.beust.kobalt.KobaltPackage";

    public static void main(String[] stringArray) throws IOException, InterruptedException {
        new Main().installAndLaunchMain(stringArray);
    }

    private void installAndLaunchMain(String[] stringArray) throws IOException, InterruptedException {
        for (int i = 0; i < stringArray.length; ++i) {
            switch (stringArray[i]) {
                case "--log": {
                    logLevel = Integer.parseInt(stringArray[i + 1]);
                    ++i;
                }
            }
        }
        Path path = this.installJarFile();
        this.launchMain(path, stringArray);
    }

    private void readProperties(Properties properties, InputStream inputStream) throws IOException {
        properties.load(inputStream);
        inputStream.close();
    }

    private Properties maybeCreateProperties() throws IOException {
        Properties properties = new Properties();
        URL uRL = this.getClass().getClassLoader().getResource(KOBALT_PROPERTIES);
        if (uRL == null) {
            throw new IllegalArgumentException("Couldn't find kobalt.properties");
        }
        this.readProperties(properties, uRL.openConnection().getInputStream());
        return properties;
    }

    private File getWrapperDir() {
        return new File(FILE_NAME, "wrapper");
    }

    private void initWrapperFile(String string) throws IOException {
        File file = new File(this.getWrapperDir(), KOBALT_WRAPPER_PROPERTIES);
        if (!file.exists()) {
            this.saveFile(file, "kobalt.version=" + string);
        }
        this.wrapperProperties.load(new FileReader(file));
    }

    private String getWrapperVersion() {
        return this.wrapperProperties.getProperty(PROPERTY_VERSION);
    }

    private boolean isWindows() {
        return System.getProperty("os.name").contains("Windows");
    }

    private Path installJarFile() throws IOException {
        Object object;
        Comparable<File> comparable;
        Properties properties = this.maybeCreateProperties();
        String string = properties.getProperty(PROPERTY_VERSION);
        this.initWrapperFile(string);
        Main.log(2, "Wrapper version: " + this.getWrapperVersion());
        String string2 = "kobalt-" + this.getWrapperVersion() + ".zip";
        new File(DISTRIBUTIONS_DIR).mkdirs();
        Path path = Paths.get(DISTRIBUTIONS_DIR, string2);
        String string3 = DISTRIBUTIONS_DIR + "/" + this.getWrapperVersion();
        Path path2 = Paths.get(string3, this.getWrapperDir().getPath() + "/" + FILE_NAME + "-" + this.getWrapperVersion() + ".jar");
        if (!Files.exists(path, new LinkOption[0]) || !Files.exists(path2, new LinkOption[0])) {
            if (!Files.exists(path, new LinkOption[0])) {
                this.download(string2, path.toFile());
            }
            boolean bl = false;
            int n = 0;
            while (!bl && n < 2) {
                try {
                    ZipFile zipFile = new ZipFile(path.toFile());
                    Enumeration<? extends ZipEntry> object2 = zipFile.entries();
                    comparable = new File(DISTRIBUTIONS_DIR);
                    comparable.mkdirs();
                    while (object2.hasMoreElements()) {
                        object = object2.nextElement();
                        File file = new File(((ZipEntry)object).getName());
                        if (((ZipEntry)object).isDirectory()) {
                            file.mkdirs();
                            continue;
                        }
                        Path path3 = Paths.get(string3, file.getPath());
                        Main.log(2, "  Writing " + ((ZipEntry)object).getName() + " to " + path3);
                        Files.createDirectories(path3.getParent(), new FileAttribute[0]);
                        Files.copy(zipFile.getInputStream((ZipEntry)object), path3, StandardCopyOption.REPLACE_EXISTING);
                    }
                    bl = true;
                }
                catch (ZipException zipException) {
                    ++n;
                    this.error("Couldn't open zip file " + path + ": " + zipException.getMessage());
                    this.error("The file is probably corrupt, downloading it again");
                    Files.delete(path);
                    this.download(string2, path.toFile());
                }
            }
        }
        if (!string.equals(this.getWrapperVersion())) {
            Main.log(2, "Copying the wrapper files");
            for (String string4 : FILES) {
                comparable = Paths.get(string3, string4);
                object = Paths.get(new File(".").getAbsolutePath(), string4);
                try {
                    if (this.isWindows() && object.toFile().exists()) {
                        Main.log(1, "Windows detected, not overwriting " + object);
                        continue;
                    }
                    Files.copy((Path)comparable, (Path)object, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException iOException) {
                    Main.log(1, "Couldn't copy " + comparable + " to " + object + ": " + iOException.getMessage());
                }
            }
            new File(KOBALTW).setExecutable(true);
        } else {
            Main.log(2, "Wrapper and current versions are identical");
        }
        return path2;
    }

    private void download(String string, File file) throws IOException {
        String string2 = URL + string;
        URL uRL = new URL(string2);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        int n = httpURLConnection.getResponseCode();
        if (n == 200) {
            String string3 = "";
            String string4 = httpURLConnection.getHeaderField("Content-Disposition");
            String string5 = httpURLConnection.getContentType();
            int n2 = httpURLConnection.getContentLength();
            if (string4 != null) {
                int n3 = string4.indexOf("filename=");
                if (n3 > 0) {
                    string3 = string4.substring(n3 + 10, string4.length() - 1);
                }
            } else {
                string3 = string2.substring(string2.lastIndexOf("/") + 1, string2.length());
            }
            Main.log(2, "Content-Type = " + string5);
            Main.log(2, "Content-Disposition = " + string4);
            Main.log(2, "Content-Length = " + n2);
            Main.log(2, "fileName = " + string3);
            InputStream inputStream = httpURLConnection.getInputStream();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            int n4 = -1;
            long l = 0L;
            byte[] byArray = new byte[100000];
            while ((n4 = inputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n4);
                l += (long)n4;
                if (n4 <= 0) continue;
                if (n2 > 0) {
                    float f = l * 100L / (long)n2;
                    Main.log2(1, "\rDownloading " + uRL + " " + f + "%");
                    continue;
                }
                Main.log2(1, ".");
            }
            Main.log2(1, "\n");
            fileOutputStream.close();
            inputStream.close();
            Main.log(1, "Downloaded " + string2);
        } else {
            this.error("No file to download. Server replied HTTP code: " + n);
        }
        httpURLConnection.disconnect();
        if (!file.exists()) {
            Main.log(2, file + " downloaded, extracting it");
        } else {
            Main.log(2, file + " already exists, extracting it");
        }
    }

    private void saveFile(File file, String string) throws IOException {
        file.getAbsoluteFile().getParentFile().mkdirs();
        file.delete();
        Main.log(2, "Wrote " + file);
        Files.write(Paths.get(file.toURI()), string.getBytes(), new OpenOption[0]);
    }

    private static void log2(int n, String string) {
        Main.p(n, string, false);
    }

    private static void log(int n, String string) {
        Main.p(n, "[Wrapper] " + string, true);
    }

    private static void p(int n, String string, boolean bl) {
        if (n <= logLevel) {
            if (bl) {
                System.out.println(string);
            } else {
                System.out.print(string);
            }
        }
    }

    private void error(String string) {
        System.out.println("[Wrapper error] *** " + string);
    }

    private void launchMain(Path path, String[] stringArray) throws IOException, InterruptedException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("java");
        arrayList.add("-jar");
        arrayList.add(path.toFile().getAbsolutePath());
        for (String string : stringArray) {
            arrayList.add(string);
        }
        ProcessBuilder processBuilder = new ProcessBuilder(arrayList);
        processBuilder.inheritIO();
        Main.log(2, "Launching " + arrayList);
        Process process = processBuilder.start();
        process.waitFor();
    }
}

